/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm, describe, it, expect, beforeEach, spyOn */
'use strict';

define(['Portal', 'backbone', 'marionette', 'jquery', 'underscore',
    'applets/wound-care-applet/core/extensions/list-generator/core/models/patients/Patient'
    ],
    function (Portal, Backbone, Marionette, $, _) {

    Portal.module('ListGenerator', function (ListGenerator, Portal, Backbone, Marionette, $, _) {
        ListGenerator.Patients = Backbone.Collection.extend({
            url: function() { return Portal.WoundCareApplet.resources.get('skin-check-patient-search').get('href'); },
            model: ListGenerator.Patient,
            parse: function(response, options) {
                if ( response["object-type"] !== "RecentlySelectedPatients" ) {

                    if (response.paging) {

                        var pageSize = response.paging.pageSize,
                            thisPage = response.paging.thisPage,
                            size = response.size;
                        
                        this.latestPage = thisPage;
                        this.results = (thisPage - 1 ) * pageSize + response.size;
                        this.totalResults = response.paging.totalResults;

                    } else {

                        this.latestPage = null;
                        this.results = 0;
                        this.totalResults = 0;
                    }
                    
                    return _.sortBy(response.patient, "displayName");
                } else {
                    this.latestPage = null;

                    if (response.size > 0) {
                        this.results = response.selectedPatient.length;
                        this.totalResults = this.results;

                        return response.selectedPatient;
                    }
                }
            }
        });
    });
});